$(function () {
    new Herop();
});

var Herop = function () {
    this._lockScroll = false;
    this.throttleDuration = 200; 
    this.$scrollBody = $('html');  
    this.scrollDirection = 'top';  
    this.findingSection = false;  
    this.sec = ['#sec1', '#sec2', '#sec3', '#sec4'];  
    this.secPos = [];
    this.scrollLocate = 0;
    this.slider1 = null;
    this.slider2 = null;
    this.startRocket = false;
    this.$gear = $('#gears2');
    this.nav = $('.nav');
    this.navList = $('.nav li');
    this.shadow = $('.shadow');
    this.menuBtn = $('#menu');
    this.currentPage = 6;

    this._initEvent();
};

Herop.prototype = {


    _initEvent: function () {
        this._scroll();
        this._plugins();
        this.windowLoad();  
        this.mouseMoveEvent();
        this.navigation();
        this.videoHandler();
    },

    _plugins: function () {
        
        this.bxSlider();
        this.tweenMax();
        this.fullpage();
    },

    _throttleScroll: function () {
        var _this = this;

        setInterval(function () {
            if (_this._lockScroll) {
                _this._lockScroll = false;
                _this.scrollEvent();
            }
        }, this.throttleDuration);
    },

    _scroll: function () {
        this._throttleScroll();

        var scrollBody = this.$scrollBody.selector === 'html' ? $(document) : this.$scrollBody;
        var _this = this;

        scrollBody.on('scroll', function () {
            _this._lockScroll = true;
            _this.scrollLocate = _this.scrollDirection === 'top' ? $(this).scrollTop() : $(this).scrollLeft();
        });
    },

    offsetOfEachSection: function () {
        if (this.findingSection) {
            var _this = this;
            var _result = null;

            this.sec.forEach(function (item, index, array) {
                if ($(item).length !== 0) {
                    switch (_this.scrollDirection) {
                        case 'top':
                            _result = $(item).offset().top;
                            break;
                        case 'left':
                            _result = $(item).offset().left;
                            break;
                    }

                    _this.secPos.push(_result);
                }
            });
        }
    },

    addWindowLoadEvent: function (func) {
        var oldonload = window.onload;
        if (typeof window.onload != 'function') {
            if (document.all && !document.querySelector) {
                window.onload = func;
            } else {
                window.onload = func();
            }
        } else {
            window.onload = function () {
                if (oldonload) {
                    oldonload();
                }
                func();
            }
        }
    },

    windowLoad: function () {
        var _this = this;

        // $(window).load({ ...
        this.addWindowLoadEvent(function () {
            _this.offsetOfEachSection();

        });
    },

    niceScroll: function () {
    
        this.$scrollBody.niceScroll({
            cursorcolor: "black",
            cursorwidth: 10,
            scrollspeed: 60,
            cursorborderradius: 0,
            mousescrollstep: 40,
            background: "none",
            cursorborder: "none",
            autohidemode: true,
            boxzoom: false,
            zindex: 990
        });
    },

    bxSlider: function () {
        var _this = this;

  
        this.slider1 = $('#strap-slider').bxSlider({
            mode: 'fade', 
            speed: 500, 
            slideMargin: 0, 
            pager: false,
            pagerSelector: '', 
            controls: false, 
            autoControls: false, 
            auto: true,
            pause: 7000, 
            minSlides: 1, 
            maxSlides: 1, 
            moveSlides: 0,
            slideWidth: 0, 
            onSliderLoad: function (currentIndex) {
            }, 
            onSlideBefore: function ($slideElement, oldIndex, newIndex) {
            }, // 슬라이드 전환 직전
            onSlideAfter: function ($slideElement, oldIndex, newIndex) {
            } 
        });
        $('.sec2 .left_btn').on('click', function () {
            _this.slider1.stopAuto();
            _this.slider1.goToPrevSlide();
        });
        $('.sec2 .right_btn').on('click', function () {
            _this.slider1.stopAuto();
            _this.slider1.goToNextSlide();
        });


        this.slider2 = $('#app-slider').bxSlider({
            mode: 'fade', 
            speed: 500, 
            slideMargin: 0, 
            pager: false, 
            pagerSelector: '', 
            controls: false, 
            autoControls: false, 
            auto: true, 
            pause: 7000, 
            minSlides: 1, 
            maxSlides: 1, 
            moveSlides: 0, 
            slideWidth: 549, 
            onSliderLoad: function (currentIndex) {
                $('#app-slider li > img').on('click', function () {
                    _this.slider2.stopAuto();
                    $(this).siblings('.popup').stop(false, true).fadeIn(500);
                });
                $('#app-slider .text').on('click', function () {
                    $(this).parent().stop(false, true).fadeOut(500);
                });
            }, 
            onSlideBefore: function ($slideElement, oldIndex, newIndex) {
            }, 
            onSlideAfter: function ($slideElement, oldIndex, newIndex) {
            } 
        });
        $('.sec3 .left_btn').on('click', function () {
            _this.slider2.stopAuto();
            _this.slider2.goToPrevSlide();
        });
        $('.sec3 .right_btn').on('click', function () {
            _this.slider2.stopAuto();
            _this.slider2.goToNextSlide();
        });
    },

    tweenMax: function () {
        
        this.tweenAnimation();
        this.timeLineAnimation();
    },

    tweenAnimation: function () {
        TweenMax.to($('#smoke'), 3, {marginBottom: 15, yoyo: true, repeat: -1, ease: Power1.easeInOut});
        TweenMax.to($('.sec2 .spanner'), 5, {marginBottom: -40, yoyo: true, repeat: -1, ease: Power1.easeInOut});
        TweenMax.to($('.sec2 .satellite'), 4, {marginTop: 15, yoyo: true, repeat: -1, ease: Power1.easeInOut});
        TweenMax.to($('.sec2 .astronaut'), 3, {marginBottom: 15, yoyo: true, repeat: -1, ease: Power1.easeInOut});

        TweenMax.to($('.sec3 .star_left_on'), 2, {opacity: 1, yoyo: true, repeat: -1, ease: Power1.easeInOut});
        TweenMax.to($('.sec3 .star_right_on'), 2.5, {opacity: 1, yoyo: true, repeat: -1, ease: Power1.easeInOut});
    },

    timeLineAnimation: function () {
        // animation 1
        (function () {
            var tween = new TimelineMax({repeat: -1});
            var $o = $('.selector');
            tween
                .set($o.find('img'), {width: 35, marginTop: 20, marginLeft: 20})
                .set($o, {opacity: 0})
                .to($o.find('img'), 1, {width: 55, marginTop: 6, marginLeft: 6, ease: Power0.easeNone}, '-=1')
                .from($o, 1, {top: 170, left: 215, ease: Power0.easeNone});
        }());
    },

    fullpage: function () {
        var _this = this;

        $('#fullpage').fullpage({
          // scrollOverflow: true,
            afterLoad: function (anchorLink, index) {
                console.log('afterLoad ' + index);

                _this.currentPage = index;

                _this.navToggle(index);

                switch (index) {
                    case 6:
                        _this.startRocket = true;
                        break;
                    case 5:
                        $('#charger-cover').show();
                        _this.gearToggle('hide');
                        _this.appToggle('.sec2', 'show');
                        $('.sec2 .text01').animate({ width: 421 }, 1000);
                        $('.sec2 .text02').delay(300).animate({ width: 444 }, 1000);
                        break;
                    case 4:
                        _this.gearToggle('hide');
                        _this.appToggle('.sec3', 'show');
                        _this.slider2.reloadSlider();
                        break;
                    case 3:
                        _this.gearToggle('hide');
                        _this.appToggle('.sec4', 'show');
                        TweenMax.to($('#phone-left'), 1, {marginLeft: 0, opacity: 1, ease: Power1.easeInOut});
                        TweenMax.to($('#phone-right'), 1, {delay: 0.3, marginRight: 0, opacity: 1, ease: Power1.easeInOut});
                        break;
                    case 2:
                        _this.gearToggle('hide');
                        _this.appToggle('.sec5', 'show');
                        break;
                    case 1:
                        if (_this.startRocket) {
                            TweenMax.to($('#rocket'), 10, {marginLeft: 1500, marginBottom: 1500, ease: Power1.easeInOut});
                            TweenMax.to($('#gear-star'), 1, {opacity: 1, yoyo: true, repeat: -1, ease: Power1.easeInOut});
                        }
                        break;
                }
            },
            onLeave: function (index, nextIndex, direction) {
                console.log('onLeave ' + index);
                switch (index) {
                    case 5:
                        $('#charger-cover').hide();
                        _this.gearToggle('show');
                        _this.appToggle('.sec2', 'hide');
                        break;
                    case 4:
                        _this.gearToggle('show');
                        _this.appToggle('.sec3', 'hide');
                        break;
                    case 3:
                        _this.gearToggle('show');
                        _this.appToggle('.sec4', 'hide');
                        break;
                    case 2:
                        if (nextIndex !== 1) {
                            _this.gearToggle('show');
                            _this.appToggle('.sec5', 'hide');
                        }
                        break;
                    case 1:

                        break;
                }
            }
        });
        $.fn.fullpage.silentMoveTo(6);
    },

    gearToggle: function (toggle) {
        switch (toggle) {
            case 'hide':
                this.$gear.stop(false, true).fadeOut(400);
                break;
            case 'show':
                this.$gear.stop(false, true).show();
                break;
        }
    },

    appToggle: function (section, toggle) {
        switch (toggle) {
            case 'hide':
                $(section + ' .app').fadeTo(0, 0);
                break;
            case 'show':
                $(section + ' .app').fadeTo(0, 1);
                break;
        }
    },

    scrollEvent: function () {
        console.log(this.scrollLocate);
    },

    mouseMoveEvent: function () {
        $(document).on("mousemove", function (e) {
            $('#stone-left').stop().animate({ marginBottom: (e.pageY * 0.03), marginLeft: -(e.pageX * 0.02) }, 100);
            $('#stone-right').stop().animate({ marginBottom: (e.pageY * 0.02), marginRight: -(e.pageX * 0.03) }, 100);
            $('.piece_01').stop().animate({ marginTop: (e.pageY * 0.02), marginLeft: -(e.pageX * 0.03) }, 100);
            $('.piece_02').stop().animate({ marginTop: (e.pageY * 0.04), marginRight: -(e.pageX * 0.02) }, 100);
            $('.piece_03').stop().animate({ marginTop: (e.pageY * 0.02), marginLeft: -(e.pageX * 0.03) }, 100);
            $('.piece_04').stop().animate({ marginTop: (e.pageY * 0.02), marginLeft: -(e.pageX * 0.04) }, 100);
            $('.piece_05').stop().animate({ marginTop: (e.pageY * 0.03), marginRight: -(e.pageX * 0.03) }, 100);
            $('.piece_06').stop().animate({ marginTop: (e.pageY * 0.02), marginRight: -(e.pageX * 0.03) }, 100);
            $('.piece_07').stop().animate({ marginTop: (e.pageY * 0.02), marginRight: -(e.pageX * 0.02) }, 100);
            $('.piece_08').stop().animate({ marginBottom: (e.pageY * 0.03), marginLeft: -(e.pageX * 0.04) }, 100);
            $('.piece_09').stop().animate({ marginBottom: (e.pageY * 0.02), marginLeft: -(e.pageX * 0.03) }, 100);
            $('.piece_10').stop().animate({ marginBottom: (e.pageY * 0.03), marginRight: -(e.pageX * 0.02) }, 100);
            $('.piece_11').stop().animate({ marginBottom: (e.pageY * 0.02), marginRight: -(e.pageX * 0.03) }, 100);
            $('.piece_12').stop().animate({ marginBottom: (e.pageY * 0.05), marginLeft: -(e.pageX * 0.03) }, 100);
        });
    },

    navigation: function () {
        var _this = this;

        this.menuBtn.on('click', function () {
            if (!$(this).hasClass('on')) {
                _this.menuToggle('on');
                $(this).addClass('on');
            } else {
                _this.menuToggle('off');
                $(this).removeClass('on');
            }
        });

        _this.navList.on('click', function () {
          var index = $(this).index() + 1;
          if (-(index - 7) === _this.currentPage) return;

            _this.menuToggle('off');
            _this.menuBtn.removeClass('on');

            $.fn.fullpage.moveTo(-(index - 7));
        });
    },

    navToggle: function (index) {
        var i = -(index - 6);

        this.navList.not(this.navList.eq(i)).removeClass('on');
        this.navList.eq(i).addClass('on');
    },

    menuToggle: function (toggle) {
        var _this = this;

        switch (toggle) {
            case 'on':
                this.shadow.stop(false, true).fadeIn(400);
                this.nav.stop(false, true).fadeIn(400);
                this.gearToggle('hide');
                $.fn.fullpage.setAllowScrolling(false);
                $.fn.fullpage.setKeyboardScrolling(false);
                break;
            case 'off':
                this.shadow.stop(false, true).fadeOut(400);
                this.nav.stop(false, true).fadeOut(400);
                this.$gear.stop(false, true).fadeIn(400);
                $.fn.fullpage.setAllowScrolling(true);
                $.fn.fullpage.setKeyboardScrolling(true);

              switch (this.currentPage) {
                case 6:
                  _this.startRocket = true;
                  break;
                case 5:
                  $('#charger-cover').show();
                  _this.gearToggle('hide');
                  _this.appToggle('.sec2', 'show');
                  $('.sec2 .text01').animate({ width: 421 }, 1000);
                  $('.sec2 .text02').delay(300).animate({ width: 444 }, 1000);
                  break;
                case 4:
                  _this.gearToggle('hide');
                  _this.appToggle('.sec3', 'show');
                  _this.slider2.reloadSlider();
                  break;
                case 3:
                  _this.gearToggle('hide');
                  _this.appToggle('.sec4', 'show');
                  TweenMax.to($('#phone-left'), 1, {marginLeft: 0, opacity: 1, ease: Power1.easeInOut});
                  TweenMax.to($('#phone-right'), 1, {delay: 0.3, marginRight: 0, opacity: 1, ease: Power1.easeInOut});
                  break;
                case 2:
                  _this.gearToggle('hide');
                  _this.appToggle('.sec5', 'show');
                  break;
                case 1:
                  if (_this.startRocket) {
                    TweenMax.to($('#rocket'), 10, {marginLeft: 1500, marginBottom: 1500, ease: Power1.easeInOut});
                    TweenMax.to($('#gear-star'), 1, {opacity: 1, yoyo: true, repeat: -1, ease: Power1.easeInOut});
                  }
                  break;
              }

                break;
        }
    },

    videoHandler: function () {
        var _this = this;
        $('.sec5 .app').on('click', function () {
            _this.videoStart();
        });
      $('.video_pop .close_btn').on('click', function () {
        _this.videoStop();
      });
    },

    videoStart: function () {
        $('.video_pop').stop(false, true).fadeIn(400).find('iframe').attr('src', 'https://www.youtube.com/embed/ZO3ydbBZITk?showinfo=0');
        $('.dimming').stop(false, true).fadeIn(400);
    },

    videoStop: function () {
      $('.video_pop').stop(false, true).fadeOut(400).find('iframe').attr('src', '');
      $('.dimming').stop(false, true).fadeOut(400);
    }

};